<?php

namespace App\Http\Controllers;

use App\Models\Membership;
use Illuminate\Http\Request;

class InvoiceController extends Controller
{
    /**
     * Display the details of a specific invoice.
     *
     * @param  int  $id  The ID of the invoice to be displayed.
     * @return \Illuminate\Contracts\View\View  The view displaying the invoice details.
     */
    public function show($id = 0)
    {
        $invoice = Membership::with('member', 'membership_type', 'transactions')->find($id);
        return view('invoice.show', compact('invoice'));
    }

    /**
     * Display a printable version of a specific invoice.
     *
     * @param  int  $id  The ID of the invoice to be printed.
     * @return \Illuminate\Contracts\View\View  The view displaying the printable invoice.
     */
    public function print($id = 0)
    {
        $invoice = Membership::with('member', 'membership_type', 'transactions')->find($id);
        return view('invoice.print', compact('invoice'));
    }
}